<?php
// ========== CHATBOT PROXY SCRIPT (FINAL - MULTI-DOMAIN SECURE VERSION) ==========

// --- الخطوة 1: تعريف قائمة الدومينات المسموح بها (القائمة البيضاء) ---
// أضف جميع مواقعك هنا. يجب أن تكون مطابقة تماماً (مع https)
$allowed_origins = [
    'https://mailwave.online',
    'https://www.mailwave.online',
    'https://mailwave.dev',
    'https://www.mailwave.dev',
    'https://app.onecompiler.com' // لا تنسَ هذا الدومين للاختبار
    // 'https://another-site.com',  // أضف أي مواقع أخرى هنا
    // 'https://www.another-site.com'
];

// --- الخطوة 2: فحص دومين الطلب القادم ---
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';

if (in_array($origin, $allowed_origins)) {
    // إذا كان الدومين موجوداً في القائمة، اسمح له بالوصول
    header("Access-Control-Allow-Origin: " . $origin);
} else {
    // إذا لم يكن موجوداً، لا تسمح له (سيتم حظره بواسطة المتصفح)
    // يمكنك إيقاف السكربت هنا لمزيد من الأمان إذا أردت
    // exit('Origin not allowed.'); 
}

// بقية إعدادات CORS
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit;
}

// -----------------------------------------

// 1. إعدادات الأمان الأساسية
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['output' => 'Error: Method Not Allowed.']);
    exit;
}

// الرابط السري للويب هوك (يبقى مخفياً هنا على الخادم)
$secretWebhookUrl = 'https://cp.foxna.us/webhook/4af602f1-e8c7-4f0c-861d-e08623232897';

// 2. قراءة البيانات القادمة من الشات بوت
$requestBody = file_get_contents('php://input');
if (!$requestBody) {
    http_response_code(400);
    echo json_encode(['output' => 'Error: No data received.']);
    exit;
}

// التحقق إذا كانت مكتبة cURL موجودة
if (!function_exists('curl_init')) {
    http_response_code(500);
    echo json_encode(['output' => 'Server Configuration Error: cURL library is missing.']);
    exit;
}

// 3. إعادة توجيه الطلب إلى الويب هوك السري باستخدام cURL
$ch = curl_init();

curl_setopt($ch, CURLOPT_URL, $secretWebhookUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $requestBody);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);

// تنفيذ الطلب
$response = curl_exec($ch);
$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

// التحقق من وجود أخطاء في cURL
if (curl_errno($ch)) {
    http_response_code(500);
    echo json_encode(['output' => "Sorry, I'm having trouble connecting right now. (Proxy Error)"]);
    curl_close($ch);
    exit;
}

curl_close($ch);

// 4. إرجاع الرد الذي تم استلامه من الويب هوك إلى الشات بوت
http_response_code($httpcode);
echo $response;
?>